/// @description Insert description here
// You can write your code in this editor
if(ds_exists(depthGrid, ds_type_grid))
{
	//Resizes the depth grid to the amount of depth parents in the room
	var _depthCount = instance_number(oDepthParent);
	var _grid = depthGrid;
	if(_depthCount <= 0) ds_grid_resize(_grid, 2, 1);
	else ds_grid_resize(_grid, 2, _depthCount);
	var _count = 0;
	
	//Adds all depth objects and their depth to the grid
	with(oDepthParent)
	{
		_grid[# 0, _count] = id;
		_grid[# 1, _count] = depthAmount;
		_count++;
	}
	
	//Sorts the grid by the depth amount
	ds_grid_sort(_grid, 1, false);
	
	for(var i = 0; i < _depthCount; i++)
	{
		var _inst = depthGrid[# 0, i];
		var _y = _inst.y;
		with(_inst)
		{
			depthDraw = true;
			event_perform(ev_draw, 0);
			depthDraw = false;
			//event_perform(ev_draw, 0);
		}
	}
	
	ds_grid_clear(_grid, 0);
}